﻿var quotas = {
    context: $(".v-quotas"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-quotasTable", this.context).a4datatable({
            ajaxAction: a4.getProjectAction("GetStatisticsQuotas", "Home"),
            columns: [
                { "Data": "ProjectId", "Title": resources.Id, "Type": "numeric" },
                { "Data": "ProjectName", "Title": resources.Project },
                { "Data": "Position", "Title": resources.StratumId, "Type": "numeric" },
                { "Data": "StatusEnum", "Title": resources.Status, "Name": "Status", "Type": "enum", "EnumType": "QuotaStatus" },
                { "Data": "Criterion", "Title": resources.Criterion },
                { "Data": "Label", "Title": resources.Label },
                { "Data": "Quota", "Title": resources.Objective, "Type": "numeric" },
                { "Data": "Schedule", "Title": resources.Schedule, "Type": "numeric" },
                { "Data": "Group", "Title": resources.Group, "Type": "numeric" },
                { "Data": "Unused", "Title": resources.Unused, "Type": "numeric" },
                { "Data": "Online", "Title": resources.Online, "Type": "numeric" },
                { "Data": "Frequence", "Title": resources.Frequency, "Type": "numeric" },
                { "Data": "ToDo", "Title": resources.ToDo, "Type": "numeric" },
                { "Data": "Percentage", "Title": "%", "Type": "numeric" },
                { "Data": "Weight", "Title": resources.Weight, "Type": "numeric" }
            ],
            stateKey: "StatisticsQuotas",
            contextMenuItems: [{ "Action": "redirect", "Params": { action: "Index", controller: "Quotas" }, "Label": resources.Quotas, "DisplayCondition": function (data) { return voxco.security.has('USE_QUOTA_DEF', data.Permissions); } }],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "redirect":
                        if (data.params.action && data.params.controller)
                            window.location = a4.getProjectAction(data.params.action, data.params.controller, { projectId: row.ProjectId });
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.StatusOpen, "AjaxParams": { "status": 0 } },
                    { "Label": resources.StatusHalfOpen, "AjaxParams": { "status": 1 } },
                    { "Label": resources.StatusClosed, "AjaxParams": { "status": 2 } }
                ]
            },
            advancedFilter: true,
            height: "full",
            localizableTexts: { "All": resources.AllStrata, "Search": resources.SearchStrata },
            cellCreated: function (evt, data) {
                if (data.fieldName == "Status")
                    $(data.cell).addClass("stratum-status-" + data.row.Status);

            }
        });
    },
    bindEvents: function () {
        quotas.context.on("click", ".h-selectStrata", function () {
            modalDialog.showWindow(a4.getProjectAction("SelectStrata", "Home"), 650, 1000, {
                afterClose: function () {
                    quotas.datatable.a4datatable("refresh");
                }
            });
        });

        quotas.context.on("click", ".h-exportQuotas", function () {
            a4.showBusyBox();
            var columns = quotas.datatable.a4datatable("getVisibleColumns");
            var tableParams = quotas.datatable.a4datatable("getTableParams");
            
            a4.callServerMethod(a4.getProjectAction("ExportQuotas", "Home"), { columns: columns.join(), tableParams: JSON.stringify(tableParams) },
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getAction("GetQuotasFile", "Home", "Project", { filePath: result, fileName: "Quotas.xlsx" });
            });
        });
    }
}

$(document).ready(function () {
    if (quotas.context.length > 0) {
        quotas.initializeDataTable();
        quotas.bindEvents();
    }
});